/**
* JQuery.windsformvalid.js
* windsformvalid 表单验证
* @author : winds
* @qq : 342377
* @version :v1.0
* @create :2012.07.24
* 1、简单表单验证功能
* 2、控件使用rule属性验证，多规则用｜分开
     特征规则：  nonull（不为空）  define（自定义正则） ajax（ajax验证）
     常用规则：  username（以字母开头，可以使用数据，-_.等符号），chinese，email，date，url，number，int，mobile，phone，post，card，ip
     动态规则：  m-n（长度验证） =id（控件值比较，多用于密码确认） >n（值大于n） <n（值小于n）
* 3、消息提示 
        nullmsg（当值为空时提示） 
        errormsg（当不满足规则时提示） 
        ajaxmsg（当ajax验证不通过时提示）
        passmsg（当验证通过时提示）
* 4、消息类型
        msgtype 0不提示消息｜1表格的后一个td提示消息｜2通过alert提示消息
        当为1时 msgtipselectorclass为提示消息的选择器样式
                msgtiperrorclass为验证未通过时样式
                msgtippassclass为验证通过时样式
* 5、样式改变
        classchange 格式（oldclass|newclass）
        当验证未通过时控件样式从oldclass变为newclass，通过时变回oldclass
* 6、回调验证
        callbackvalid 自定义验证函数，通过返回true，未通过返回false
*/

;(function($) {
    $.fn.windsformvalid = function(options) {
        var self = $(this);
        var defaults = {
            "defaultnullmsg": "不能为空!",
            "defaulterrormsg": "格式不正确!",
            "defaultajaxmsg": "该名称已存在!",
            "defaultpassmsg": "验证通过!",
            "defaultcallbackmsg": "未通过回调验证!",
            "msgtype": 0,
            "msgtipnormalclass": "",
            "msgtiperrorclass": "",
            "msgtippassclass": "",
            "classchange": "",
            "callbackvalid": null
        };

        //验证正则
        var ruleRegExp = {
            "username": /^[a-zA-Z]{1}([a-zA-Z0-9]|[._-])+$/,
            "chinese": /^[\u4E00-\u9FA5\uf900-\ufa2d]+$/,
            "email": /^\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/,
            "date": /^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$/,
            "url": /^((http|https|ftp):\/\/)?\w+(\.\w+)+.*$/,
            "number": /^([1-9]\d*(\.\d+)?)|(\d+(\.\d+))$/,
            "int": /^\d+$/,
            "mobile": /^(13|15|18)[0-9]{9}$/,
            "phone": /^0\d{2,4}-?\d{7,8}$/,
            "post": /^[1-9][0-9]{5}$/,
            "card": /(^\d{15}$)|(^\d{17}([0-9]|(X|x))$)/,
            "ip": /([0-9]{1,3}\.{1}){3}[0-9]{1,3}/
        };

        //复杂定义规则
        var defineRegExp = {
            "len": /^\d+-\d+$/,
            "equal": /^=\w+$/,
            "greaterthan": /^>\d+$/,
            "lessthan": /^<\d+$/
        };
        var run = 0;
        //参数合并
        var param = $.extend({}, defaults, options || {});
        //得到该ID
        var selectorid = self.attr('ID');
        //得到要验证的对象
        var objs = self.find("[rule]");
        //记住原来的提示信息
        objs.each(function(i) {
            objs[i].tips = $(this).parent().next().find('.' + param.msgtipselectorclass).html();
        });
        //绑定提交
        self.bind("submit", function() {
            if (run == 1) {
                return false;
            }
            return formValid();
        });

        //是否改变样式
        var isclasschange = false;
        var oldclass = "";
        var newclass = "";
        if (param.classchange) {
            isclasschange = true;
            var strcg = param.classchange.split('|');
            if (strcg.length == 2) {
                oldclass = strcg[0];
                newclass = strcg[1];
            }
            else {
                newclass = strcg[0];
            }
        }

        //提交验证方法
        var formValid = function() {
            run = 1;
            var flagValid = true;

            objs.each(function() {
                if (!singleValid($(this))) {
                    flagValid = false;
                    //如果用alert方式显示消息，当一个验证不通过时就返回
                    if (param.msgtype == 2) {
                        run = 0;
                        return flagValid;
                    }
                }
            });
            //如果都通过了验证，则调用回调验证
            if (flagValid && param.callbackvalid != null && typeof param.callbackvalid === "function") {
                flagValid = param.callbackvalid();
                // && param.msgtype == 2
                if (!flagValid) {
                    alert(param.defaultcallbackmsg);
                }
            }
            run = 0;
            return flagValid;
        };

        //单个控件验证
        var singleValid = function(obj) {
            var flag = true;
            var rule = obj.attr("rule") || '';
            var nullmsg = obj.attr("nullmsg") || param.defaultnullmsg;
            var errormsg = obj.attr("errormsg") || param.defaulterrormsg;
            var ajaxmsg = obj.attr("ajaxmsg") || param.defaultajaxmsg;
            var passmsg = obj.attr("passmsg") || param.defaultpassmsg;

            if (rule == "") {
                return true;
            }
            var value = getvalue(obj);
            //多规则通过|分开
            var rules = rule.split('|');
            var ruleslen = rules.length;
            //先还原样式
            doValidBefore(obj, passmsg);
            for (var i = 0; i < ruleslen; i++) {
                switch (rules[i]) {
                    case 'nonull':
                        //验证不能为空
                        if (value == "") {
                            flag = false;
                            doValidWrong(obj, nullmsg);
                            return flag;
                        }
                        break;
                    case 'define':
                        //自定义正则验证
                        if (value != "") {
                            var patrnstr = obj.attr("define");
                            if (patrnstr != "") {
                                var patrn = new RegExp(patrnstr.replace(new RegExp("\/", "gm"), ""));
                                if (!patrn.test(value)) {
                                    flag = false;
                                    doValidWrong(obj, errormsg);
                                    return flag;
                                }
                            }
                        }
                        break;
                    case 'ajax':
                        //通过ajax验证
                        var ajaxurl = obj.attr('ajaxurl');
                        if (value != "" && ajaxurl != "") {
                            var ajaxrs = ajaxValid(ajaxurl, value);
                            if (ajaxrs.status == 0) {
                                ajaxmsg = ajaxrs.msg != "" ? ajaxrs.msg : ajaxmsg;
                                flag = false;
                                doValidWrong(obj, ajaxmsg);
                                return flag;
                            }
                        }
                    default:
                        //其它规则
                        //验证规则
                        if (value != "") {
                            for (var ruleName in ruleRegExp) {
                                if (ruleName == rules[i]) {
                                    var patrn = new RegExp(ruleRegExp[ruleName]);
                                    if (!patrn.test(value)) {
                                        flag = false;
                                        doValidWrong(obj, errormsg);
                                        return flag;
                                    }
                                }
                            }
                        }
                        //复杂规则
                        //1、判断长短
                        var lenpatrn = new RegExp(defineRegExp.len);
                        if (lenpatrn.test(rules[i])) {
                            var strchecklen = rules[i].split('-');
                            var minlen = parseInt(strchecklen[0], 10);
                            var maxlen = parseInt(strchecklen[1], 10);
                            if (value.length < minlen || value.length > maxlen) {
                                flag = false;
                                doValidWrong(obj, errormsg);
                                return flag;
                            }
                        }
                        //2、判断与别的ID相等
                        var equalpatrn = new RegExp(defineRegExp.equal);
                        if (equalpatrn.test(rules[i])) {
                            var equalid = rules[i].substr(1);
                            if (value != getvalue($('#' + equalid))) {
                                flag = false;
                                doValidWrong(obj, errormsg);
                                return flag;
                            }
                        }
                        //3、判断大于多少
                        var greaterthanpatrn = new RegExp(defineRegExp.greaterthan);
                        if (greaterthanpatrn.test(rules[i])) {
                            var thanvalue = parseInt(rules[i].substr(1));
                            if (value <= thanvalue) {
                                flag = false;
                                doValidWrong(obj, errormsg);
                                return flag;
                            }
                        }
                        //4、判断小于多少
                        var lessthanpatrn = new RegExp(defineRegExp.lessthan);
                        if (lessthanpatrn.test(rules[i])) {
                            var thanvalue = parseInt(rules[i].substr(1));
                            if (value >= thanvalue) {
                                flag = false;
                                doValidWrong(obj, errormsg);
                                return flag;
                            }
                        }
                        break;
                }
            }
            //验证通过
            if (flag) {
                doValidPassed(obj, passmsg);
            }
            return flag;
        };

        //得到控件值
        var getvalue = function(o) {
            var strval;
            if (o.is(":radio")) {
                strval = self.find(":radio[name='" + o.attr("name") + "']:checked").val();
            }
            else if (o.is(":checkbox")) {
                strval = self.find(":checkbox[name='" + o.attr("name") + "']:checked").val();
            }
            else {
                strval = o.val();
            }
            return $.trim(strval);
        };

        //验证前还原样式
        var doValidBefore = function(o) {
            if (isclasschange) {
                classChange(o, newclass, oldclass);
            }

            var msgobj = o.parent().next().find('.' + param.msgtiperrorclass);
            if (msgobj.length > 0) {
                classChange(msgobj, param.msgtiperrorclass, param.msgtipnormalclass);
                msgobj.html('');
            }
            msgobj = o.parent().next().find('.' + param.msgtippassclass);
            if (msgobj.length > 0) {
                classChange(msgobj, param.msgtippassclass, param.msgtipnormalclass);
                msgobj.html('');
            }

        };

        //验证未通过
        var doValidWrong = function(o, msg) {
            if (isclasschange) {
                classChange(o, oldclass, newclass);
            }
            switch (param.msgtype) {
                case 1:
                    //后面显示
                    var msgobj = o.parent().next().find('.' + param.msgtipnormalclass);
                    classChange(msgobj, param.msgtipnormalclass, param.msgtiperrorclass);
                    msgobj.html(msg);
                    break;
                case 2:
                    //alert弹窗提示
                    alert(msg);
                    break;
                default:
                    break;
            }
        };

        //验证通过后
        var doValidPassed = function(o, msg) {
            if (param.msgtype == 1) {
                var msgobj = o.parent().next().find('.' + param.msgtipnormalclass);
                classChange(msgobj, param.msgtipnormalclass, param.msgtippassclass);
                if (msg) {
                    msgobj.html(msg);
                }
                else {
                    msgobj.html('');
                }
            }
        };

        //改变Class
        var classChange = function(o, oldclass, newclass) {
            if (oldclass) {
                o.removeClass(oldclass).addClass(newclass);
            }
            else {
                o.addClass(newclass);
            }
        };

        //通过ajax验证
        var ajaxValid = function(url, value) {
            var rs = null;
            //设置5秒超时
            $.ajax({
                type: "POST",
                dataType: "json",
                url: url,
                async: false,
                timeout: 5000,
                data: {
                    "name": value
                },
                success: function(data) {
                    rs = data;
                },
                error: function(data) {
                    rs = { "status": 1, "msg": "" };
                }
            });
            return rs;
        };
    };
})(jQuery);
